import { StyleSheet, View, Dimensions, Text } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
import { ProfileStyles } from "../../../../screens/Profile/ProfileStyle";

const ProductDetailsSkeleton = () => {
    return (
        <>
            <View style={styles.itemCont}>
                <View style={styles.marginHorizontal}>
                    <SkeletonElement
                        wrapperStyle={styles.skeletonWrapper(220, 20)}
                    />
                    <View
                        style={[
                            ProfileStyles.hrLine,
                            styles.marginTop15,
                        ]}
                    />
                    <View style={styles.marginTop15}>
                        <SkeletonElement
                            wrapperStyle={styles.wrapperCommonStyle}
                        />
                    </View>
                    <View
                        style={[
                            ProfileStyles.hrLine,
                            styles.marginVertical
                        ]}
                    />
                    <SkeletonElement
                        wrapperStyle={styles.wrapperCommonStyle}
                    />
                    <View
                        style={[
                            ProfileStyles.hrLine,
                            styles.marginTop15,
                        ]}
                    />
                    <View style={styles.marginVertical}>
                        <SkeletonElement
                            wrapperStyle={styles.skeletonWrapper(180, 20)}
                        />
                    </View>
                    <View style={styles.flexProperty}>
                        <SkeletonElement
                            wrapperStyle={styles.skeletonWrapper(100, 20)}
                        />
                        <SkeletonElement
                            wrapperStyle={styles.skeletonWrapper(100, 20)}
                        />
                        <SkeletonElement
                            wrapperStyle={styles.skeletonWrapper(100, 20)}
                        />
                    </View>
                    <View style={styles.twiceSkeletonWrapper}>
                        <SkeletonElement
                            wrapperStyle={styles.skeletonWrapperStyle4}
                        />
                        <SkeletonElement
                            wrapperStyle={styles.skeletonWrapper(80, 70)}
                        />
                    </View>
                </View>
            </View>
        </>
    );
};

export default ProductDetailsSkeleton;

const styles = StyleSheet.create({
    flexProperty: {
        flexDirection: "row",
        justifyContent: "space-between",
    },
    itemCont: {
        backgroundColor: "#FFFFFF",
        flex: 1
    },
    marginTop15: {
        marginTop: dpr(15)
    },
    marginHorizontal: {
        marginHorizontal: dpr(20)
    },
    marginVertical: {
        marginVertical: dpr(15),
    },
    skeletonWrapperStyle1: {
        width: dpr("wf"),
        height: dpr(270),
        marginBottom: dpr(10),
    },
    skeletonWrapperStyle2: {
        width: dpr(180),
        height: dpr(10),
        marginBottom: dpr(10),
    },
    skeletonWrapperStyle3: {
        width: dpr(40),
        height: dpr(10),
        marginBottom: dpr(10),
    },
    skeletonWrapperStyle4: {
        width: dpr(80),
        height: dpr(70),
        marginRight: dpr(20),
    },
    wrapperCommonStyle: {
        width: dpr("wf") - dpr(40),
        height: dpr(30),
    },
    twiceSkeletonWrapper: {
        flexDirection: "row",
        marginTop: dpr(10),
    },
    skeletonWrapper: (width, height) => ({
        width: dpr(width),
        height: dpr(height),
    })
});
